/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.architectury.core.RegistryEntry;
import me.shedaniel.architectury.registry.Registry;
import me.shedaniel.architectury.registry.RegistrySupplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArchitecturyWrappedRegistry<T, S>
implements Registry<T> {
    private final Registry<S> sourceRegistry;
    private final Function<T, S> to;
    private final Function<S, T> from;

    public ArchitecturyWrappedRegistry(Registry<S> sourceRegistry, Function<T, S> to, Function<S, T> from) {
        this.sourceRegistry = sourceRegistry;
        this.to = to;
        this.from = from;
    }

    @NotNull
    public RegistrySupplier<T> delegateSupplied(ResourceLocation id) {
        return new WrappedRegistrySupplier(this.sourceRegistry.delegateSupplied(id));
    }

    @NotNull
    public RegistrySupplier<T> registerSupplied(ResourceLocation id, Supplier<T> supplier) {
        return new WrappedRegistrySupplier(this.sourceRegistry.registerSupplied(id, () -> this.to.apply(supplier.get())));
    }

    @Nullable
    public ResourceLocation getId(T obj) {
        return this.sourceRegistry.getId(this.to.apply(obj));
    }

    public int getRawId(T obj) {
        return this.sourceRegistry.getRawId(this.to.apply(obj));
    }

    public Optional<RegistryKey<T>> getKey(T obj) {
        return this.sourceRegistry.getKey(this.to.apply(obj)).map(this::convert);
    }

    @Nullable
    public T get(ResourceLocation id) {
        return this.from.apply(this.sourceRegistry.get(id));
    }

    @Nullable
    public T byRawId(int rawId) {
        return this.from.apply(this.sourceRegistry.byRawId(rawId));
    }

    public boolean contains(ResourceLocation id) {
        return this.sourceRegistry.contains(id);
    }

    public boolean containsValue(T obj) {
        return this.sourceRegistry.containsValue(this.to.apply(obj));
    }

    public Set<ResourceLocation> getIds() {
        return this.sourceRegistry.getIds();
    }

    public Set<Map.Entry<RegistryKey<T>, T>> entrySet() {
        return this.sourceRegistry.entrySet().stream().map(x -> new Map.Entry<RegistryKey<T>, T>((Map.Entry)x){
            final /* synthetic */ Map.Entry val$x;
            {
                this.val$x = entry;
            }

            @Override
            public RegistryKey<T> getKey() {
                return ArchitecturyWrappedRegistry.this.convert((RegistryKey)this.val$x.getKey());
            }

            @Override
            public T getValue() {
                return ArchitecturyWrappedRegistry.this.from.apply(this.val$x.getValue());
            }

            @Override
            public T setValue(T t) {
                return ArchitecturyWrappedRegistry.this.from.apply(this.val$x.setValue(ArchitecturyWrappedRegistry.this.to.apply(t)));
            }
        }).collect(Collectors.toSet());
    }

    public RegistryKey<? extends net.minecraft.util.registry.Registry<T>> key() {
        return this.sourceRegistry.key();
    }

    private RegistryKey<T> convert(RegistryKey<S> key) {
        return key;
    }

    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final Iterator<S> prev;
            {
                this.prev = ArchitecturyWrappedRegistry.this.sourceRegistry.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.prev.hasNext();
            }

            @Override
            public T next() {
                return ArchitecturyWrappedRegistry.this.from.apply(this.prev.next());
            }

            @Override
            public void remove() {
                this.prev.remove();
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                this.prev.forEachRemaining((? super E x) -> action.accept((Object)ArchitecturyWrappedRegistry.this.from.apply(x)));
            }
        };
    }

    public class WrappedRegistrySupplier
    implements RegistrySupplier<T> {
        private final RegistrySupplier<S> source;

        public WrappedRegistrySupplier(RegistrySupplier<S> source) {
            this.source = source;
        }

        @NotNull
        public ResourceLocation getRegistryId() {
            return this.source.getRegistryId();
        }

        @NotNull
        public ResourceLocation getId() {
            return this.source.getId();
        }

        public boolean isPresent() {
            return this.source.isPresent();
        }

        public T get() {
            return ArchitecturyWrappedRegistry.this.from.apply(this.source.get());
        }
    }

    public static class Wrapper<T, W extends Wrapper<T, W>>
    extends RegistryEntry<W> {
        private final T value;

        public Wrapper(T value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Wrapper wrapper = (Wrapper)((Object)o);
            return Objects.equals(this.value, wrapper.value);
        }

        public T get() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "W:" + ((Object)((Object)this)).getClass().getSimpleName() + ":{" + this.value.toString() + "}";
        }
    }
}

